package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Scope(
    awsAccounts: Option[Iterable[zio.aws.auditmanager.model.AWSAccount]] = None,
    awsServices: Option[Iterable[zio.aws.auditmanager.model.AWSService]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Scope = {
    import Scope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Scope
      .builder()
      .optionallyWith(
        awsAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccounts)
      .optionallyWith(
        awsServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsServices)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Scope.ReadOnly =
    zio.aws.auditmanager.model.Scope.wrap(buildAwsValue())
}
object Scope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Scope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Scope =
      zio.aws.auditmanager.model.Scope(
        awsAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        awsServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccounts
        : Option[List[zio.aws.auditmanager.model.AWSAccount.ReadOnly]]
    def awsServices
        : Option[List[zio.aws.auditmanager.model.AWSService.ReadOnly]]
    def getAwsAccounts: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AWSAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccounts", awsAccounts)
    def getAwsServices: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AWSService.ReadOnly
    ]] = AwsError.unwrapOptionField("awsServices", awsServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Scope
  ) extends zio.aws.auditmanager.model.Scope.ReadOnly {
    override val awsAccounts
        : Option[List[zio.aws.auditmanager.model.AWSAccount.ReadOnly]] = scala
      .Option(impl.awsAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AWSAccount.wrap(item)
        }.toList
      )
    override val awsServices
        : Option[List[zio.aws.auditmanager.model.AWSService.ReadOnly]] = scala
      .Option(impl.awsServices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AWSService.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Scope
  ): zio.aws.auditmanager.model.Scope.ReadOnly = new Wrapper(impl)
}
