package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{UrlLink, HyperlinkName}
import scala.jdk.CollectionConverters._
final case class URL(
    hyperlinkName: Option[HyperlinkName] = None,
    link: Option[UrlLink] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.URL = {
    import URL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.URL
      .builder()
      .optionallyWith(
        hyperlinkName.map(value =>
          HyperlinkName.unwrap(value): java.lang.String
        )
      )(_.hyperlinkName)
      .optionallyWith(
        link.map(value => UrlLink.unwrap(value): java.lang.String)
      )(_.link)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.URL.ReadOnly =
    zio.aws.auditmanager.model.URL.wrap(buildAwsValue())
}
object URL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.auditmanager.model.URL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.URL = zio.aws.auditmanager.model
      .URL(hyperlinkName.map(value => value), link.map(value => value))
    def hyperlinkName: Option[HyperlinkName]
    def link: Option[UrlLink]
    def getHyperlinkName: ZIO[Any, AwsError, HyperlinkName] =
      AwsError.unwrapOptionField("hyperlinkName", hyperlinkName)
    def getLink: ZIO[Any, AwsError, UrlLink] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.URL
  ) extends zio.aws.auditmanager.model.URL.ReadOnly {
    override val hyperlinkName: Option[HyperlinkName] = scala
      .Option(impl.hyperlinkName())
      .map(value => zio.aws.auditmanager.model.primitives.HyperlinkName(value))
    override val link: Option[UrlLink] = scala
      .Option(impl.link())
      .map(value => zio.aws.auditmanager.model.primitives.UrlLink(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.URL
  ): zio.aws.auditmanager.model.URL.ReadOnly = new Wrapper(impl)
}
