package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{Token, KeywordValue}
import scala.jdk.CollectionConverters._
final case class ListKeywordsForDataSourceResponse(
    keywords: Option[Iterable[KeywordValue]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse = {
    import ListKeywordsForDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
      .builder()
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            KeywordValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly =
    zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse
      .wrap(buildAwsValue())
}
object ListKeywordsForDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse =
      zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse(
        keywords.map(value => value),
        nextToken.map(value => value)
      )
    def keywords: Option[List[KeywordValue]]
    def nextToken: Option[Token]
    def getKeywords: ZIO[Any, AwsError, List[KeywordValue]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ) extends zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly {
    override val keywords: Option[List[KeywordValue]] = scala
      .Option(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.primitives.KeywordValue(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ): zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
