package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentEvidenceFolderName,
  Timestamp,
  Integer,
  UUID,
  ControlName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AssessmentEvidenceFolder(
    name: Option[AssessmentEvidenceFolderName] = None,
    date: Option[Timestamp] = None,
    assessmentId: Option[UUID] = None,
    controlSetId: Option[ControlSetId] = None,
    controlId: Option[UUID] = None,
    id: Option[UUID] = None,
    dataSource: Option[String] = None,
    author: Option[String] = None,
    totalEvidence: Option[Integer] = None,
    assessmentReportSelectionCount: Option[Integer] = None,
    controlName: Option[ControlName] = None,
    evidenceResourcesIncludedCount: Option[Integer] = None,
    evidenceByTypeConfigurationDataCount: Option[Integer] = None,
    evidenceByTypeManualCount: Option[Integer] = None,
    evidenceByTypeComplianceCheckCount: Option[Integer] = None,
    evidenceByTypeComplianceCheckIssuesCount: Option[Integer] = None,
    evidenceByTypeUserActivityCount: Option[Integer] = None,
    evidenceAwsServiceSourceCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder = {
    import AssessmentEvidenceFolder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
      .builder()
      .optionallyWith(
        name.map(value =>
          AssessmentEvidenceFolderName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(date.map(value => Timestamp.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        controlId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.controlId)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(dataSource.map(value => value: java.lang.String))(
        _.dataSource
      )
      .optionallyWith(author.map(value => value: java.lang.String))(_.author)
      .optionallyWith(totalEvidence.map(value => value: java.lang.Integer))(
        _.totalEvidence
      )
      .optionallyWith(
        assessmentReportSelectionCount.map(value => value: java.lang.Integer)
      )(_.assessmentReportSelectionCount)
      .optionallyWith(
        controlName.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.controlName)
      .optionallyWith(
        evidenceResourcesIncludedCount.map(value => value: java.lang.Integer)
      )(_.evidenceResourcesIncludedCount)
      .optionallyWith(
        evidenceByTypeConfigurationDataCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeConfigurationDataCount)
      .optionallyWith(
        evidenceByTypeManualCount.map(value => value: java.lang.Integer)
      )(_.evidenceByTypeManualCount)
      .optionallyWith(
        evidenceByTypeComplianceCheckCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeComplianceCheckCount)
      .optionallyWith(
        evidenceByTypeComplianceCheckIssuesCount.map(value =>
          value: java.lang.Integer
        )
      )(_.evidenceByTypeComplianceCheckIssuesCount)
      .optionallyWith(
        evidenceByTypeUserActivityCount.map(value => value: java.lang.Integer)
      )(_.evidenceByTypeUserActivityCount)
      .optionallyWith(
        evidenceAwsServiceSourceCount.map(value => value: java.lang.Integer)
      )(_.evidenceAwsServiceSourceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly =
    zio.aws.auditmanager.model.AssessmentEvidenceFolder.wrap(buildAwsValue())
}
object AssessmentEvidenceFolder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentEvidenceFolder =
      zio.aws.auditmanager.model.AssessmentEvidenceFolder(
        name.map(value => value),
        date.map(value => value),
        assessmentId.map(value => value),
        controlSetId.map(value => value),
        controlId.map(value => value),
        id.map(value => value),
        dataSource.map(value => value),
        author.map(value => value),
        totalEvidence.map(value => value),
        assessmentReportSelectionCount.map(value => value),
        controlName.map(value => value),
        evidenceResourcesIncludedCount.map(value => value),
        evidenceByTypeConfigurationDataCount.map(value => value),
        evidenceByTypeManualCount.map(value => value),
        evidenceByTypeComplianceCheckCount.map(value => value),
        evidenceByTypeComplianceCheckIssuesCount.map(value => value),
        evidenceByTypeUserActivityCount.map(value => value),
        evidenceAwsServiceSourceCount.map(value => value)
      )
    def name: Option[AssessmentEvidenceFolderName]
    def date: Option[Timestamp]
    def assessmentId: Option[UUID]
    def controlSetId: Option[ControlSetId]
    def controlId: Option[UUID]
    def id: Option[UUID]
    def dataSource: Option[String]
    def author: Option[String]
    def totalEvidence: Option[Integer]
    def assessmentReportSelectionCount: Option[Integer]
    def controlName: Option[ControlName]
    def evidenceResourcesIncludedCount: Option[Integer]
    def evidenceByTypeConfigurationDataCount: Option[Integer]
    def evidenceByTypeManualCount: Option[Integer]
    def evidenceByTypeComplianceCheckCount: Option[Integer]
    def evidenceByTypeComplianceCheckIssuesCount: Option[Integer]
    def evidenceByTypeUserActivityCount: Option[Integer]
    def evidenceAwsServiceSourceCount: Option[Integer]
    def getName: ZIO[Any, AwsError, AssessmentEvidenceFolderName] =
      AwsError.unwrapOptionField("name", name)
    def getDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("date", date)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getControlId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("controlId", controlId)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getAuthor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("author", author)
    def getTotalEvidence: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalEvidence", totalEvidence)
    def getAssessmentReportSelectionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "assessmentReportSelectionCount",
        assessmentReportSelectionCount
      )
    def getControlName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("controlName", controlName)
    def getEvidenceResourcesIncludedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceResourcesIncludedCount",
        evidenceResourcesIncludedCount
      )
    def getEvidenceByTypeConfigurationDataCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeConfigurationDataCount",
        evidenceByTypeConfigurationDataCount
      )
    def getEvidenceByTypeManualCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("evidenceByTypeManualCount", evidenceByTypeManualCount)
    def getEvidenceByTypeComplianceCheckCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeComplianceCheckCount",
        evidenceByTypeComplianceCheckCount
      )
    def getEvidenceByTypeComplianceCheckIssuesCount
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "evidenceByTypeComplianceCheckIssuesCount",
      evidenceByTypeComplianceCheckIssuesCount
    )
    def getEvidenceByTypeUserActivityCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceByTypeUserActivityCount",
        evidenceByTypeUserActivityCount
      )
    def getEvidenceAwsServiceSourceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "evidenceAwsServiceSourceCount",
        evidenceAwsServiceSourceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ) extends zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly {
    override val name: Option[AssessmentEvidenceFolderName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.auditmanager.model.primitives
          .AssessmentEvidenceFolderName(value)
      )
    override val date: Option[Timestamp] = scala
      .Option(impl.date())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val assessmentId: Option[UUID] = scala
      .Option(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val controlSetId: Option[ControlSetId] = scala
      .Option(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val controlId: Option[UUID] = scala
      .Option(impl.controlId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val dataSource: Option[String] =
      scala.Option(impl.dataSource()).map(value => value: String)
    override val author: Option[String] =
      scala.Option(impl.author()).map(value => value: String)
    override val totalEvidence: Option[Integer] =
      scala.Option(impl.totalEvidence()).map(value => value: Integer)
    override val assessmentReportSelectionCount: Option[Integer] = scala
      .Option(impl.assessmentReportSelectionCount())
      .map(value => value: Integer)
    override val controlName: Option[ControlName] = scala
      .Option(impl.controlName())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val evidenceResourcesIncludedCount: Option[Integer] = scala
      .Option(impl.evidenceResourcesIncludedCount())
      .map(value => value: Integer)
    override val evidenceByTypeConfigurationDataCount: Option[Integer] = scala
      .Option(impl.evidenceByTypeConfigurationDataCount())
      .map(value => value: Integer)
    override val evidenceByTypeManualCount: Option[Integer] = scala
      .Option(impl.evidenceByTypeManualCount())
      .map(value => value: Integer)
    override val evidenceByTypeComplianceCheckCount: Option[Integer] = scala
      .Option(impl.evidenceByTypeComplianceCheckCount())
      .map(value => value: Integer)
    override val evidenceByTypeComplianceCheckIssuesCount: Option[Integer] =
      scala
        .Option(impl.evidenceByTypeComplianceCheckIssuesCount())
        .map(value => value: Integer)
    override val evidenceByTypeUserActivityCount: Option[Integer] = scala
      .Option(impl.evidenceByTypeUserActivityCount())
      .map(value => value: Integer)
    override val evidenceAwsServiceSourceCount: Option[Integer] = scala
      .Option(impl.evidenceAwsServiceSourceCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentEvidenceFolder
  ): zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly = new Wrapper(
    impl
  )
}
