package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token}
import scala.jdk.CollectionConverters._
final case class GetDelegationsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest = {
    import GetDelegationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetDelegationsRequest.ReadOnly =
    zio.aws.auditmanager.model.GetDelegationsRequest.wrap(buildAwsValue())
}
object GetDelegationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetDelegationsRequest =
      zio.aws.auditmanager.model.GetDelegationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest
  ) extends zio.aws.auditmanager.model.GetDelegationsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest
  ): zio.aws.auditmanager.model.GetDelegationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
