package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterAccountResponse(
    status: Option[zio.aws.auditmanager.model.AccountStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse = {
    import DeregisterAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly =
    zio.aws.auditmanager.model.DeregisterAccountResponse.wrap(buildAwsValue())
}
object DeregisterAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DeregisterAccountResponse =
      zio.aws.auditmanager.model
        .DeregisterAccountResponse(status.map(value => value))
    def status: Option[zio.aws.auditmanager.model.AccountStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AccountStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse
  ) extends zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly {
    override val status: Option[zio.aws.auditmanager.model.AccountStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.AccountStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregisterAccountResponse
  ): zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly =
    new Wrapper(impl)
}
