package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ActionPlanTitle,
  TagValue,
  TestingInformation,
  ActionPlanInstructions,
  ControlDescription,
  ControlName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateControlRequest(
    name: ControlName,
    description: Option[ControlDescription] = None,
    testingInformation: Option[TestingInformation] = None,
    actionPlanTitle: Option[ActionPlanTitle] = None,
    actionPlanInstructions: Option[ActionPlanInstructions] = None,
    controlMappingSources: Iterable[
      zio.aws.auditmanager.model.CreateControlMappingSource
    ],
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateControlRequest = {
    import CreateControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateControlRequest
      .builder()
      .name(ControlName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        testingInformation.map(value =>
          TestingInformation.unwrap(value): java.lang.String
        )
      )(_.testingInformation)
      .optionallyWith(
        actionPlanTitle.map(value =>
          ActionPlanTitle.unwrap(value): java.lang.String
        )
      )(_.actionPlanTitle)
      .optionallyWith(
        actionPlanInstructions.map(value =>
          ActionPlanInstructions.unwrap(value): java.lang.String
        )
      )(_.actionPlanInstructions)
      .controlMappingSources(controlMappingSources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.CreateControlRequest.ReadOnly =
    zio.aws.auditmanager.model.CreateControlRequest.wrap(buildAwsValue())
}
object CreateControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateControlRequest =
      zio.aws.auditmanager.model.CreateControlRequest(
        name,
        description.map(value => value),
        testingInformation.map(value => value),
        actionPlanTitle.map(value => value),
        actionPlanInstructions.map(value => value),
        controlMappingSources.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def name: ControlName
    def description: Option[ControlDescription]
    def testingInformation: Option[TestingInformation]
    def actionPlanTitle: Option[ActionPlanTitle]
    def actionPlanInstructions: Option[ActionPlanInstructions]
    def controlMappingSources
        : List[zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ControlName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTestingInformation: ZIO[Any, AwsError, TestingInformation] =
      AwsError.unwrapOptionField("testingInformation", testingInformation)
    def getActionPlanTitle: ZIO[Any, AwsError, ActionPlanTitle] =
      AwsError.unwrapOptionField("actionPlanTitle", actionPlanTitle)
    def getActionPlanInstructions: ZIO[Any, AwsError, ActionPlanInstructions] =
      AwsError.unwrapOptionField(
        "actionPlanInstructions",
        actionPlanInstructions
      )
    def getControlMappingSources: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly
    ]] = ZIO.succeed(controlMappingSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlRequest
  ) extends zio.aws.auditmanager.model.CreateControlRequest.ReadOnly {
    override val name: ControlName =
      zio.aws.auditmanager.model.primitives.ControlName(impl.name())
    override val description: Option[ControlDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlDescription(value)
      )
    override val testingInformation: Option[TestingInformation] = scala
      .Option(impl.testingInformation())
      .map(value =>
        zio.aws.auditmanager.model.primitives.TestingInformation(value)
      )
    override val actionPlanTitle: Option[ActionPlanTitle] = scala
      .Option(impl.actionPlanTitle())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanTitle(value)
      )
    override val actionPlanInstructions: Option[ActionPlanInstructions] = scala
      .Option(impl.actionPlanInstructions())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ActionPlanInstructions(value)
      )
    override val controlMappingSources
        : List[zio.aws.auditmanager.model.CreateControlMappingSource.ReadOnly] =
      impl
        .controlMappingSources()
        .asScala
        .map { item =>
          zio.aws.auditmanager.model.CreateControlMappingSource.wrap(item)
        }
        .toList
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlRequest
  ): zio.aws.auditmanager.model.CreateControlRequest.ReadOnly = new Wrapper(
    impl
  )
}
