package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{IamArn, Timestamp, NonEmptyString}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ChangeLog(
    objectType: Option[zio.aws.auditmanager.model.ObjectTypeEnum] = None,
    objectName: Option[NonEmptyString] = None,
    action: Option[zio.aws.auditmanager.model.ActionEnum] = None,
    createdAt: Option[Timestamp] = None,
    createdBy: Option[IamArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ChangeLog = {
    import ChangeLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ChangeLog
      .builder()
      .optionallyWith(objectType.map(value => value.unwrap))(_.objectType)
      .optionallyWith(
        objectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.objectName)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ChangeLog.ReadOnly =
    zio.aws.auditmanager.model.ChangeLog.wrap(buildAwsValue())
}
object ChangeLog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ChangeLog =
      zio.aws.auditmanager.model.ChangeLog(
        objectType.map(value => value),
        objectName.map(value => value),
        action.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value)
      )
    def objectType: Option[zio.aws.auditmanager.model.ObjectTypeEnum]
    def objectName: Option[NonEmptyString]
    def action: Option[zio.aws.auditmanager.model.ActionEnum]
    def createdAt: Option[Timestamp]
    def createdBy: Option[IamArn]
    def getObjectType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ObjectTypeEnum] =
      AwsError.unwrapOptionField("objectType", objectType)
    def getObjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectName", objectName)
    def getAction: ZIO[Any, AwsError, zio.aws.auditmanager.model.ActionEnum] =
      AwsError.unwrapOptionField("action", action)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ) extends zio.aws.auditmanager.model.ChangeLog.ReadOnly {
    override val objectType: Option[zio.aws.auditmanager.model.ObjectTypeEnum] =
      scala
        .Option(impl.objectType())
        .map(value => zio.aws.auditmanager.model.ObjectTypeEnum.wrap(value))
    override val objectName: Option[NonEmptyString] = scala
      .Option(impl.objectName())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val action: Option[zio.aws.auditmanager.model.ActionEnum] = scala
      .Option(impl.action())
      .map(value => zio.aws.auditmanager.model.ActionEnum.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Option[IamArn] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ChangeLog
  ): zio.aws.auditmanager.model.ChangeLog.ReadOnly = new Wrapper(impl)
}
