package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode, UUID}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDelegationByAssessmentError(
    delegationId: Option[UUID] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError = {
    import BatchDeleteDelegationByAssessmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
      .builder()
      .optionallyWith(
        delegationId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.delegationId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly =
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError
      .wrap(buildAwsValue())
}
object BatchDeleteDelegationByAssessmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError =
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError(
        delegationId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def delegationId: Option[UUID]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getDelegationId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("delegationId", delegationId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ) extends zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly {
    override val delegationId: Option[UUID] = scala
      .Option(impl.delegationId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentError
  ): zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly =
    new Wrapper(impl)
}
