package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode}
import scala.jdk.CollectionConverters._
final case class BatchCreateDelegationByAssessmentError(
    createDelegationRequest: Option[
      zio.aws.auditmanager.model.CreateDelegationRequest
    ] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError = {
    import BatchCreateDelegationByAssessmentError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError
      .builder()
      .optionallyWith(
        createDelegationRequest.map(value => value.buildAwsValue())
      )(_.createDelegationRequest)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly =
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError
      .wrap(buildAwsValue())
}
object BatchCreateDelegationByAssessmentError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError =
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError(
        createDelegationRequest.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def createDelegationRequest
        : Option[zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getCreateDelegationRequest: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createDelegationRequest",
      createDelegationRequest
    )
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError
  ) extends zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly {
    override val createDelegationRequest
        : Option[zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly] =
      scala
        .Option(impl.createDelegationRequest())
        .map(value =>
          zio.aws.auditmanager.model.CreateDelegationRequest.wrap(value)
        )
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentError
  ): zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly =
    new Wrapper(impl)
}
