package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentFrameworkShareRequest(
    requestId: UUID,
    requestType: zio.aws.auditmanager.model.ShareRequestType,
    action: zio.aws.auditmanager.model.ShareRequestAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest = {
    import UpdateAssessmentFrameworkShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest
      .builder()
      .requestId(UUID.unwrap(requestId): java.lang.String)
      .requestType(requestType.unwrap)
      .action(action.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareRequest
      .wrap(buildAwsValue())
}
object UpdateAssessmentFrameworkShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareRequest =
      zio.aws.auditmanager.model
        .UpdateAssessmentFrameworkShareRequest(requestId, requestType, action)
    def requestId: UUID
    def requestType: zio.aws.auditmanager.model.ShareRequestType
    def action: zio.aws.auditmanager.model.ShareRequestAction
    def getRequestId: ZIO[Any, Nothing, UUID] = ZIO.succeed(requestId)
    def getRequestType
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ShareRequestType] =
      ZIO.succeed(requestType)
    def getAction
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ShareRequestAction] =
      ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareRequest.ReadOnly {
    override val requestId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.requestId())
    override val requestType: zio.aws.auditmanager.model.ShareRequestType =
      zio.aws.auditmanager.model.ShareRequestType.wrap(impl.requestType())
    override val action: zio.aws.auditmanager.model.ShareRequestAction =
      zio.aws.auditmanager.model.ShareRequestAction.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareRequest.ReadOnly =
    new Wrapper(impl)
}
