package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.GenericArn
import scala.jdk.CollectionConverters._
final case class Resource(
    arn: Option[GenericArn] = None,
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Resource
      .builder()
      .optionallyWith(
        arn.map(value => GenericArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Resource.ReadOnly =
    zio.aws.auditmanager.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Resource =
      zio.aws.auditmanager.model
        .Resource(arn.map(value => value), value.map(value => value))
    def arn: Option[GenericArn]
    def value: Option[String]
    def getArn: ZIO[Any, AwsError, GenericArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Resource
  ) extends zio.aws.auditmanager.model.Resource.ReadOnly {
    override val arn: Option[GenericArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.auditmanager.model.primitives.GenericArn(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Resource
  ): zio.aws.auditmanager.model.Resource.ReadOnly = new Wrapper(impl)
}
