package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListControlDomainInsightsResponse(
    controlDomainInsights: Option[
      Iterable[zio.aws.auditmanager.model.ControlDomainInsights]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse = {
    import ListControlDomainInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse
      .builder()
      .optionallyWith(
        controlDomainInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlDomainInsights)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListControlDomainInsightsResponse
      .wrap(buildAwsValue())
}
object ListControlDomainInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListControlDomainInsightsResponse =
      zio.aws.auditmanager.model.ListControlDomainInsightsResponse(
        controlDomainInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def controlDomainInsights: Option[
      List[zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getControlDomainInsights: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly
    ]] =
      AwsError.unwrapOptionField("controlDomainInsights", controlDomainInsights)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse
  ) extends zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly {
    override val controlDomainInsights: Option[
      List[zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly]
    ] = scala
      .Option(impl.controlDomainInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlDomainInsights.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse
  ): zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
