package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssessmentReportUrlResponse(
    preSignedUrl: Option[zio.aws.auditmanager.model.URL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse = {
    import GetAssessmentReportUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse
      .builder()
      .optionallyWith(preSignedUrl.map(value => value.buildAwsValue()))(
        _.preSignedUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentReportUrlResponse
      .wrap(buildAwsValue())
}
object GetAssessmentReportUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentReportUrlResponse =
      zio.aws.auditmanager.model.GetAssessmentReportUrlResponse(
        preSignedUrl.map(value => value.asEditable)
      )
    def preSignedUrl: Option[zio.aws.auditmanager.model.URL.ReadOnly]
    def getPreSignedUrl
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.URL.ReadOnly] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse
  ) extends zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly {
    override val preSignedUrl: Option[zio.aws.auditmanager.model.URL.ReadOnly] =
      scala
        .Option(impl.preSignedUrl())
        .map(value => zio.aws.auditmanager.model.URL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlResponse
  ): zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly =
    new Wrapper(impl)
}
