package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{Timestamp, UUID, NonEmptyString}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ControlInsightsMetadataItem(
    name: Option[NonEmptyString] = None,
    id: Option[UUID] = None,
    evidenceInsights: Option[zio.aws.auditmanager.model.EvidenceInsights] =
      None,
    lastUpdated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem = {
    import ControlInsightsMetadataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(evidenceInsights.map(value => value.buildAwsValue()))(
        _.evidenceInsights
      )
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly =
    zio.aws.auditmanager.model.ControlInsightsMetadataItem.wrap(buildAwsValue())
}
object ControlInsightsMetadataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlInsightsMetadataItem =
      zio.aws.auditmanager.model.ControlInsightsMetadataItem(
        name.map(value => value),
        id.map(value => value),
        evidenceInsights.map(value => value.asEditable),
        lastUpdated.map(value => value)
      )
    def name: Option[NonEmptyString]
    def id: Option[UUID]
    def evidenceInsights
        : Option[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly]
    def lastUpdated: Option[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getEvidenceInsights: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceInsights.ReadOnly
    ] = AwsError.unwrapOptionField("evidenceInsights", evidenceInsights)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ) extends zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val evidenceInsights
        : Option[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly] = scala
      .Option(impl.evidenceInsights())
      .map(value => zio.aws.auditmanager.model.EvidenceInsights.wrap(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem
  ): zio.aws.auditmanager.model.ControlInsightsMetadataItem.ReadOnly =
    new Wrapper(impl)
}
