package zio.aws.auditmanager.model
import java.time.Instant
import zio.aws.auditmanager.model.primitives.{
  Timestamp,
  NullableInteger,
  UUID,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ControlDomainInsights(
    name: Option[NonEmptyString] = None,
    id: Option[UUID] = None,
    controlsCountByNoncompliantEvidence: Option[NullableInteger] = None,
    totalControlsCount: Option[NullableInteger] = None,
    evidenceInsights: Option[zio.aws.auditmanager.model.EvidenceInsights] =
      None,
    lastUpdated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights = {
    import ControlDomainInsights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        controlsCountByNoncompliantEvidence.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.controlsCountByNoncompliantEvidence)
      .optionallyWith(
        totalControlsCount.map(value => NullableInteger.unwrap(value): Integer)
      )(_.totalControlsCount)
      .optionallyWith(evidenceInsights.map(value => value.buildAwsValue()))(
        _.evidenceInsights
      )
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly =
    zio.aws.auditmanager.model.ControlDomainInsights.wrap(buildAwsValue())
}
object ControlDomainInsights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlDomainInsights =
      zio.aws.auditmanager.model.ControlDomainInsights(
        name.map(value => value),
        id.map(value => value),
        controlsCountByNoncompliantEvidence.map(value => value),
        totalControlsCount.map(value => value),
        evidenceInsights.map(value => value.asEditable),
        lastUpdated.map(value => value)
      )
    def name: Option[NonEmptyString]
    def id: Option[UUID]
    def controlsCountByNoncompliantEvidence: Option[NullableInteger]
    def totalControlsCount: Option[NullableInteger]
    def evidenceInsights
        : Option[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly]
    def lastUpdated: Option[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getControlsCountByNoncompliantEvidence
        : ZIO[Any, AwsError, NullableInteger] = AwsError.unwrapOptionField(
      "controlsCountByNoncompliantEvidence",
      controlsCountByNoncompliantEvidence
    )
    def getTotalControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("totalControlsCount", totalControlsCount)
    def getEvidenceInsights: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceInsights.ReadOnly
    ] = AwsError.unwrapOptionField("evidenceInsights", evidenceInsights)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ) extends zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val controlsCountByNoncompliantEvidence: Option[NullableInteger] =
      scala
        .Option(impl.controlsCountByNoncompliantEvidence())
        .map(value =>
          zio.aws.auditmanager.model.primitives.NullableInteger(value)
        )
    override val totalControlsCount: Option[NullableInteger] = scala
      .Option(impl.totalControlsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val evidenceInsights
        : Option[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly] = scala
      .Option(impl.evidenceInsights())
      .map(value => zio.aws.auditmanager.model.EvidenceInsights.wrap(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ): zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly = new Wrapper(
    impl
  )
}
