package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchCreateDelegationByAssessmentResponse(
    delegations: Option[Iterable[zio.aws.auditmanager.model.Delegation]] = None,
    errors: Option[Iterable[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse = {
    import BatchCreateDelegationByAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
      .builder()
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse
      .wrap(buildAwsValue())
}
object BatchCreateDelegationByAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse =
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse(
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def delegations
        : Option[List[zio.aws.auditmanager.model.Delegation.ReadOnly]]
    def errors: Option[List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]]
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Delegation.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ) extends zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly {
    override val delegations
        : Option[List[zio.aws.auditmanager.model.Delegation.ReadOnly]] = scala
      .Option(impl.delegations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Delegation.wrap(item)
        }.toList
      )
    override val errors: Option[List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ): zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
