package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ComplianceType,
  FrameworkDescription,
  FrameworkName,
  UUID
}
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentFrameworkRequest(
    frameworkId: UUID,
    name: FrameworkName,
    description: Option[FrameworkDescription] = None,
    complianceType: Option[ComplianceType] = None,
    controlSets: Iterable[
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest = {
    import UpdateAssessmentFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest
      .builder()
      .frameworkId(UUID.unwrap(frameworkId): java.lang.String)
      .name(FrameworkName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .controlSets(controlSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest
      .wrap(buildAwsValue())
}
object UpdateAssessmentFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest =
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest(
        frameworkId,
        name,
        description.map(value => value),
        complianceType.map(value => value),
        controlSets.map { item =>
          item.asEditable
        }
      )
    def frameworkId: UUID
    def name: FrameworkName
    def description: Option[FrameworkDescription]
    def complianceType: Option[ComplianceType]
    def controlSets: List[
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly
    ]
    def getFrameworkId: ZIO[Any, Nothing, UUID] = ZIO.succeed(frameworkId)
    def getName: ZIO[Any, Nothing, FrameworkName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getControlSets: ZIO[Any, Nothing, List[
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly
    ]] = ZIO.succeed(controlSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest.ReadOnly {
    override val frameworkId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.frameworkId())
    override val name: FrameworkName =
      zio.aws.auditmanager.model.primitives.FrameworkName(impl.name())
    override val description: Option[FrameworkDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
      )
    override val complianceType: Option[ComplianceType] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.auditmanager.model.primitives.ComplianceType(value))
    override val controlSets: List[
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet.ReadOnly
    ] = impl
      .controlSets()
      .asScala
      .map { item =>
        zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentFrameworkRequest.ReadOnly =
    new Wrapper(impl)
}
