package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait SourceFrequency {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.SourceFrequency
}
object SourceFrequency {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.SourceFrequency
  ): zio.aws.auditmanager.model.SourceFrequency = value match {
    case software.amazon.awssdk.services.auditmanager.model.SourceFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceFrequency.DAILY =>
      val r = DAILY
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceFrequency.WEEKLY =>
      val r = WEEKLY
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceFrequency.MONTHLY =>
      val r = MONTHLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.SourceFrequency {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceFrequency =
      software.amazon.awssdk.services.auditmanager.model.SourceFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object DAILY extends zio.aws.auditmanager.model.SourceFrequency {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceFrequency =
      software.amazon.awssdk.services.auditmanager.model.SourceFrequency.DAILY
  }
  case object WEEKLY extends zio.aws.auditmanager.model.SourceFrequency {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceFrequency =
      software.amazon.awssdk.services.auditmanager.model.SourceFrequency.WEEKLY
  }
  case object MONTHLY extends zio.aws.auditmanager.model.SourceFrequency {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceFrequency =
      software.amazon.awssdk.services.auditmanager.model.SourceFrequency.MONTHLY
  }
}
