package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListNotificationsResponse(
    notifications: Option[Iterable[zio.aws.auditmanager.model.Notification]] =
      None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse = {
    import ListNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
      .builder()
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListNotificationsResponse.wrap(buildAwsValue())
}
object ListNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListNotificationsResponse =
      zio.aws.auditmanager.model.ListNotificationsResponse(
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def notifications
        : Option[List[zio.aws.auditmanager.model.Notification.ReadOnly]]
    def nextToken: Option[Token]
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Notification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ) extends zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly {
    override val notifications
        : Option[List[zio.aws.auditmanager.model.Notification.ReadOnly]] = scala
      .Option(impl.notifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Notification.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListNotificationsResponse
  ): zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
