package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListAssessmentsResponse(
    assessmentMetadata: Option[
      Iterable[zio.aws.auditmanager.model.AssessmentMetadataItem]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse = {
    import ListAssessmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse
      .builder()
      .optionallyWith(
        assessmentMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assessmentMetadata)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentsResponse.wrap(buildAwsValue())
}
object ListAssessmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListAssessmentsResponse =
      zio.aws.auditmanager.model.ListAssessmentsResponse(
        assessmentMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def assessmentMetadata: Option[
      List[zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getAssessmentMetadata: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly
    ]] = AwsError.unwrapOptionField("assessmentMetadata", assessmentMetadata)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly {
    override val assessmentMetadata: Option[
      List[zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly]
    ] = scala
      .Option(impl.assessmentMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentMetadataItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse
  ): zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
