package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class GetEvidenceFoldersByAssessmentControlResponse(
    evidenceFolders: Option[
      Iterable[zio.aws.auditmanager.model.AssessmentEvidenceFolder]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse = {
    import GetEvidenceFoldersByAssessmentControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
      .builder()
      .optionallyWith(
        evidenceFolders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evidenceFolders)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
      .wrap(buildAwsValue())
}
object GetEvidenceFoldersByAssessmentControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse =
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse(
        evidenceFolders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evidenceFolders: Option[
      List[zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getEvidenceFolders: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly
    ]] = AwsError.unwrapOptionField("evidenceFolders", evidenceFolders)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly {
    override val evidenceFolders: Option[
      List[zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly]
    ] = scala
      .Option(impl.evidenceFolders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentEvidenceFolder.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
  ): zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly =
    new Wrapper(impl)
}
