package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssessmentFrameworkResponse(
    framework: Option[zio.aws.auditmanager.model.Framework] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse = {
    import GetAssessmentFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse
      .builder()
      .optionallyWith(framework.map(value => value.buildAwsValue()))(
        _.framework
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentFrameworkResponse
      .wrap(buildAwsValue())
}
object GetAssessmentFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentFrameworkResponse =
      zio.aws.auditmanager.model.GetAssessmentFrameworkResponse(
        framework.map(value => value.asEditable)
      )
    def framework: Option[zio.aws.auditmanager.model.Framework.ReadOnly]
    def getFramework
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Framework.ReadOnly] =
      AwsError.unwrapOptionField("framework", framework)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse
  ) extends zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly {
    override val framework
        : Option[zio.aws.auditmanager.model.Framework.ReadOnly] = scala
      .Option(impl.framework())
      .map(value => zio.aws.auditmanager.model.Framework.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkResponse
  ): zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly =
    new Wrapper(impl)
}
