package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  FrameworkName,
  Filename,
  Timestamp,
  TagValue,
  FrameworkDescription,
  ComplianceType,
  LastUpdatedBy,
  UUID,
  ControlSources,
  CreatedBy,
  TagKey
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Framework(
    arn: Option[AuditManagerArn] = None,
    id: Option[UUID] = None,
    name: Option[FrameworkName] = None,
    `type`: Option[zio.aws.auditmanager.model.FrameworkType] = None,
    complianceType: Option[ComplianceType] = None,
    description: Option[FrameworkDescription] = None,
    logo: Option[Filename] = None,
    controlSources: Option[ControlSources] = None,
    controlSets: Option[Iterable[zio.aws.auditmanager.model.ControlSet]] = None,
    createdAt: Option[Timestamp] = None,
    lastUpdatedAt: Option[Timestamp] = None,
    createdBy: Option[CreatedBy] = None,
    lastUpdatedBy: Option[LastUpdatedBy] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Framework = {
    import Framework.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Framework
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => FrameworkName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        description.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        logo.map(value => Filename.unwrap(value): java.lang.String)
      )(_.logo)
      .optionallyWith(
        controlSources.map(value =>
          ControlSources.unwrap(value): java.lang.String
        )
      )(_.controlSources)
      .optionallyWith(
        controlSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlSets)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Framework.ReadOnly =
    zio.aws.auditmanager.model.Framework.wrap(buildAwsValue())
}
object Framework {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Framework
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Framework =
      zio.aws.auditmanager.model.Framework(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        complianceType.map(value => value),
        description.map(value => value),
        logo.map(value => value),
        controlSources.map(value => value),
        controlSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[AuditManagerArn]
    def id: Option[UUID]
    def name: Option[FrameworkName]
    def `type`: Option[zio.aws.auditmanager.model.FrameworkType]
    def complianceType: Option[ComplianceType]
    def description: Option[FrameworkDescription]
    def logo: Option[Filename]
    def controlSources: Option[ControlSources]
    def controlSets
        : Option[List[zio.aws.auditmanager.model.ControlSet.ReadOnly]]
    def createdAt: Option[Timestamp]
    def lastUpdatedAt: Option[Timestamp]
    def createdBy: Option[CreatedBy]
    def lastUpdatedBy: Option[LastUpdatedBy]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.auditmanager.model.FrameworkType] =
      AwsError.unwrapOptionField("type", `type`)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLogo: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("logo", logo)
    def getControlSources: ZIO[Any, AwsError, ControlSources] =
      AwsError.unwrapOptionField("controlSources", controlSources)
    def getControlSets: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlSet.ReadOnly
    ]] = AwsError.unwrapOptionField("controlSets", controlSets)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Framework
  ) extends zio.aws.auditmanager.model.Framework.ReadOnly {
    override val arn: Option[AuditManagerArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Option[FrameworkName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.FrameworkName(value))
    override val `type`: Option[zio.aws.auditmanager.model.FrameworkType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.auditmanager.model.FrameworkType.wrap(value))
    override val complianceType: Option[ComplianceType] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.auditmanager.model.primitives.ComplianceType(value))
    override val description: Option[FrameworkDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
      )
    override val logo: Option[Filename] = scala
      .Option(impl.logo())
      .map(value => zio.aws.auditmanager.model.primitives.Filename(value))
    override val controlSources: Option[ControlSources] = scala
      .Option(impl.controlSources())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSources(value))
    override val controlSets
        : Option[List[zio.aws.auditmanager.model.ControlSet.ReadOnly]] = scala
      .Option(impl.controlSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlSet.wrap(item)
        }.toList
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Option[LastUpdatedBy] = scala
      .Option(impl.lastUpdatedBy())
      .map(value => zio.aws.auditmanager.model.primitives.LastUpdatedBy(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Framework
  ): zio.aws.auditmanager.model.Framework.ReadOnly = new Wrapper(impl)
}
