package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.AccountId
import scala.jdk.CollectionConverters._
final case class DeregisterOrganizationAdminAccountRequest(
    adminAccountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest = {
    import DeregisterOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest
      .builder()
      .optionallyWith(
        adminAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.adminAccountId)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object DeregisterOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest =
      zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest(
        adminAccountId.map(value => value)
      )
    def adminAccountId: Option[AccountId]
    def getAdminAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("adminAccountId", adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest
  ) extends zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: Option[AccountId] = scala
      .Option(impl.adminAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest
  ): zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
