package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait ControlStatus {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.ControlStatus
}
object ControlStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ControlStatus
  ): zio.aws.auditmanager.model.ControlStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.ControlStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlStatus.UNDER_REVIEW =>
      val r = UNDER_REVIEW
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlStatus.REVIEWED =>
      val r = REVIEWED
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UNDER_REVIEW extends zio.aws.auditmanager.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlStatus.UNDER_REVIEW
  }
  case object REVIEWED extends zio.aws.auditmanager.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlStatus.REVIEWED
  }
  case object INACTIVE extends zio.aws.auditmanager.model.ControlStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlStatus.INACTIVE
  }
}
