package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  TroubleshootingText,
  SourceDescription,
  SourceName,
  UUID
}
import scala.jdk.CollectionConverters._
final case class ControlMappingSource(
    sourceId: Option[UUID] = None,
    sourceName: Option[SourceName] = None,
    sourceDescription: Option[SourceDescription] = None,
    sourceSetUpOption: Option[zio.aws.auditmanager.model.SourceSetUpOption] =
      None,
    sourceType: Option[zio.aws.auditmanager.model.SourceType] = None,
    sourceKeyword: Option[zio.aws.auditmanager.model.SourceKeyword] = None,
    sourceFrequency: Option[zio.aws.auditmanager.model.SourceFrequency] = None,
    troubleshootingText: Option[TroubleshootingText] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlMappingSource = {
    import ControlMappingSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlMappingSource
      .builder()
      .optionallyWith(
        sourceId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(
        sourceName.map(value => SourceName.unwrap(value): java.lang.String)
      )(_.sourceName)
      .optionallyWith(
        sourceDescription.map(value =>
          SourceDescription.unwrap(value): java.lang.String
        )
      )(_.sourceDescription)
      .optionallyWith(sourceSetUpOption.map(value => value.unwrap))(
        _.sourceSetUpOption
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(sourceKeyword.map(value => value.buildAwsValue()))(
        _.sourceKeyword
      )
      .optionallyWith(sourceFrequency.map(value => value.unwrap))(
        _.sourceFrequency
      )
      .optionallyWith(
        troubleshootingText.map(value =>
          TroubleshootingText.unwrap(value): java.lang.String
        )
      )(_.troubleshootingText)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlMappingSource.ReadOnly =
    zio.aws.auditmanager.model.ControlMappingSource.wrap(buildAwsValue())
}
object ControlMappingSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlMappingSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlMappingSource =
      zio.aws.auditmanager.model.ControlMappingSource(
        sourceId.map(value => value),
        sourceName.map(value => value),
        sourceDescription.map(value => value),
        sourceSetUpOption.map(value => value),
        sourceType.map(value => value),
        sourceKeyword.map(value => value.asEditable),
        sourceFrequency.map(value => value),
        troubleshootingText.map(value => value)
      )
    def sourceId: Option[UUID]
    def sourceName: Option[SourceName]
    def sourceDescription: Option[SourceDescription]
    def sourceSetUpOption: Option[zio.aws.auditmanager.model.SourceSetUpOption]
    def sourceType: Option[zio.aws.auditmanager.model.SourceType]
    def sourceKeyword: Option[zio.aws.auditmanager.model.SourceKeyword.ReadOnly]
    def sourceFrequency: Option[zio.aws.auditmanager.model.SourceFrequency]
    def troubleshootingText: Option[TroubleshootingText]
    def getSourceId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getSourceName: ZIO[Any, AwsError, SourceName] =
      AwsError.unwrapOptionField("sourceName", sourceName)
    def getSourceDescription: ZIO[Any, AwsError, SourceDescription] =
      AwsError.unwrapOptionField("sourceDescription", sourceDescription)
    def getSourceSetUpOption
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceSetUpOption] =
      AwsError.unwrapOptionField("sourceSetUpOption", sourceSetUpOption)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceKeyword: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.SourceKeyword.ReadOnly
    ] = AwsError.unwrapOptionField("sourceKeyword", sourceKeyword)
    def getSourceFrequency
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.SourceFrequency] =
      AwsError.unwrapOptionField("sourceFrequency", sourceFrequency)
    def getTroubleshootingText: ZIO[Any, AwsError, TroubleshootingText] =
      AwsError.unwrapOptionField("troubleshootingText", troubleshootingText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlMappingSource
  ) extends zio.aws.auditmanager.model.ControlMappingSource.ReadOnly {
    override val sourceId: Option[UUID] = scala
      .Option(impl.sourceId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val sourceName: Option[SourceName] = scala
      .Option(impl.sourceName())
      .map(value => zio.aws.auditmanager.model.primitives.SourceName(value))
    override val sourceDescription: Option[SourceDescription] = scala
      .Option(impl.sourceDescription())
      .map(value =>
        zio.aws.auditmanager.model.primitives.SourceDescription(value)
      )
    override val sourceSetUpOption
        : Option[zio.aws.auditmanager.model.SourceSetUpOption] = scala
      .Option(impl.sourceSetUpOption())
      .map(value => zio.aws.auditmanager.model.SourceSetUpOption.wrap(value))
    override val sourceType: Option[zio.aws.auditmanager.model.SourceType] =
      scala
        .Option(impl.sourceType())
        .map(value => zio.aws.auditmanager.model.SourceType.wrap(value))
    override val sourceKeyword
        : Option[zio.aws.auditmanager.model.SourceKeyword.ReadOnly] = scala
      .Option(impl.sourceKeyword())
      .map(value => zio.aws.auditmanager.model.SourceKeyword.wrap(value))
    override val sourceFrequency
        : Option[zio.aws.auditmanager.model.SourceFrequency] = scala
      .Option(impl.sourceFrequency())
      .map(value => zio.aws.auditmanager.model.SourceFrequency.wrap(value))
    override val troubleshootingText: Option[TroubleshootingText] = scala
      .Option(impl.troubleshootingText())
      .map(value =>
        zio.aws.auditmanager.model.primitives.TroubleshootingText(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlMappingSource
  ): zio.aws.auditmanager.model.ControlMappingSource.ReadOnly = new Wrapper(
    impl
  )
}
