package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode, UUID}
import scala.jdk.CollectionConverters._
final case class AssessmentReportEvidenceError(
    evidenceId: Option[UUID] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError = {
    import AssessmentReportEvidenceError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
      .builder()
      .optionallyWith(
        evidenceId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.evidenceId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly =
    zio.aws.auditmanager.model.AssessmentReportEvidenceError
      .wrap(buildAwsValue())
}
object AssessmentReportEvidenceError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentReportEvidenceError =
      zio.aws.auditmanager.model.AssessmentReportEvidenceError(
        evidenceId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def evidenceId: Option[UUID]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getEvidenceId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("evidenceId", evidenceId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ) extends zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly {
    override val evidenceId: Option[UUID] = scala
      .Option(impl.evidenceId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ): zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly =
    new Wrapper(impl)
}
