package zio.aws.auditmanager.model
import java.time.Instant
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  ControlSetsCount,
  FrameworkName,
  Filename,
  Timestamp,
  FrameworkDescription,
  ComplianceType,
  UUID,
  ControlsCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssessmentFrameworkMetadata(
    arn: Option[AuditManagerArn] = None,
    id: Option[UUID] = None,
    `type`: Option[zio.aws.auditmanager.model.FrameworkType] = None,
    name: Option[FrameworkName] = None,
    description: Option[FrameworkDescription] = None,
    logo: Option[Filename] = None,
    complianceType: Option[ComplianceType] = None,
    controlsCount: Option[ControlsCount] = None,
    controlSetsCount: Option[ControlSetsCount] = None,
    createdAt: Option[Timestamp] = None,
    lastUpdatedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkMetadata = {
    import AssessmentFrameworkMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkMetadata
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => FrameworkName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        logo.map(value => Filename.unwrap(value): java.lang.String)
      )(_.logo)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        controlsCount.map(value => ControlsCount.unwrap(value): Integer)
      )(_.controlsCount)
      .optionallyWith(
        controlSetsCount.map(value => ControlSetsCount.unwrap(value): Integer)
      )(_.controlSetsCount)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly =
    zio.aws.auditmanager.model.AssessmentFrameworkMetadata.wrap(buildAwsValue())
}
object AssessmentFrameworkMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentFrameworkMetadata =
      zio.aws.auditmanager.model.AssessmentFrameworkMetadata(
        arn.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        logo.map(value => value),
        complianceType.map(value => value),
        controlsCount.map(value => value),
        controlSetsCount.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def arn: Option[AuditManagerArn]
    def id: Option[UUID]
    def `type`: Option[zio.aws.auditmanager.model.FrameworkType]
    def name: Option[FrameworkName]
    def description: Option[FrameworkDescription]
    def logo: Option[Filename]
    def complianceType: Option[ComplianceType]
    def controlsCount: Option[ControlsCount]
    def controlSetsCount: Option[ControlSetsCount]
    def createdAt: Option[Timestamp]
    def lastUpdatedAt: Option[Timestamp]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.auditmanager.model.FrameworkType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLogo: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("logo", logo)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getControlsCount: ZIO[Any, AwsError, ControlsCount] =
      AwsError.unwrapOptionField("controlsCount", controlsCount)
    def getControlSetsCount: ZIO[Any, AwsError, ControlSetsCount] =
      AwsError.unwrapOptionField("controlSetsCount", controlSetsCount)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkMetadata
  ) extends zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly {
    override val arn: Option[AuditManagerArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val `type`: Option[zio.aws.auditmanager.model.FrameworkType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.auditmanager.model.FrameworkType.wrap(value))
    override val name: Option[FrameworkName] = scala
      .Option(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.FrameworkName(value))
    override val description: Option[FrameworkDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
      )
    override val logo: Option[Filename] = scala
      .Option(impl.logo())
      .map(value => zio.aws.auditmanager.model.primitives.Filename(value))
    override val complianceType: Option[ComplianceType] = scala
      .Option(impl.complianceType())
      .map(value => zio.aws.auditmanager.model.primitives.ComplianceType(value))
    override val controlsCount: Option[ControlsCount] = scala
      .Option(impl.controlsCount())
      .map(value => zio.aws.auditmanager.model.primitives.ControlsCount(value))
    override val controlSetsCount: Option[ControlSetsCount] = scala
      .Option(impl.controlSetsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ControlSetsCount(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkMetadata
  ): zio.aws.auditmanager.model.AssessmentFrameworkMetadata.ReadOnly =
    new Wrapper(impl)
}
