package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait ActionEnum {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.ActionEnum
}
object ActionEnum {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ActionEnum
  ): zio.aws.auditmanager.model.ActionEnum = value match {
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.UPDATE_METADATA =>
      val r = UPDATE_METADATA
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.UNDER_REVIEW =>
      val r = UNDER_REVIEW
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.REVIEWED =>
      val r = REVIEWED
      r
    case software.amazon.awssdk.services.auditmanager.model.ActionEnum.IMPORT_EVIDENCE =>
      val r = IMPORT_EVIDENCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.CREATE
  }
  case object UPDATE_METADATA extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.UPDATE_METADATA
  }
  case object ACTIVE extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.ACTIVE
  }
  case object INACTIVE extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.INACTIVE
  }
  case object DELETE extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.DELETE
  }
  case object UNDER_REVIEW extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.UNDER_REVIEW
  }
  case object REVIEWED extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.REVIEWED
  }
  case object IMPORT_EVIDENCE extends zio.aws.auditmanager.model.ActionEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ActionEnum =
      software.amazon.awssdk.services.auditmanager.model.ActionEnum.IMPORT_EVIDENCE
  }
}
