package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  AssessmentDescription,
  AssessmentName,
  UUID
}
import scala.jdk.CollectionConverters._
final case class UpdateAssessmentRequest(
    assessmentId: UUID,
    assessmentName: Option[AssessmentName] = None,
    assessmentDescription: Option[AssessmentDescription] = None,
    scope: zio.aws.auditmanager.model.Scope,
    assessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination
    ] = None,
    roles: Option[Iterable[zio.aws.auditmanager.model.Role]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest = {
    import UpdateAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        assessmentDescription.map(value =>
          AssessmentDescription.unwrap(value): java.lang.String
        )
      )(_.assessmentDescription)
      .scope(scope.buildAwsValue())
      .optionallyWith(
        assessmentReportsDestination.map(value => value.buildAwsValue())
      )(_.assessmentReportsDestination)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentRequest.wrap(buildAwsValue())
}
object UpdateAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentRequest =
      zio.aws.auditmanager.model.UpdateAssessmentRequest(
        assessmentId,
        assessmentName.map(value => value),
        assessmentDescription.map(value => value),
        scope.asEditable,
        assessmentReportsDestination.map(value => value.asEditable),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def assessmentId: UUID
    def assessmentName: Option[AssessmentName]
    def assessmentDescription: Option[AssessmentDescription]
    def scope: zio.aws.auditmanager.model.Scope.ReadOnly
    def assessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ]
    def roles: Option[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAssessmentDescription: ZIO[Any, AwsError, AssessmentDescription] =
      AwsError.unwrapOptionField("assessmentDescription", assessmentDescription)
    def getScope: ZIO[Any, Nothing, zio.aws.auditmanager.model.Scope.ReadOnly] =
      ZIO.succeed(scope)
    def getAssessmentReportsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "assessmentReportsDestination",
      assessmentReportsDestination
    )
    def getRoles
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("roles", roles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val assessmentName: Option[AssessmentName] = scala
      .Option(impl.assessmentName())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val assessmentDescription: Option[AssessmentDescription] = scala
      .Option(impl.assessmentDescription())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AssessmentDescription(value)
      )
    override val scope: zio.aws.auditmanager.model.Scope.ReadOnly =
      zio.aws.auditmanager.model.Scope.wrap(impl.scope())
    override val assessmentReportsDestination: Option[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = scala
      .Option(impl.assessmentReportsDestination())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentReportsDestination.wrap(value)
      )
    override val roles: Option[List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      scala
        .Option(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Role.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
