package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.IamArn
import scala.jdk.CollectionConverters._
final case class Role(
    roleType: Option[zio.aws.auditmanager.model.RoleType] = None,
    roleArn: Option[IamArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Role = {
    import Role.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Role
      .builder()
      .optionallyWith(roleType.map(value => value.unwrap))(_.roleType)
      .optionallyWith(
        roleArn.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Role.ReadOnly =
    zio.aws.auditmanager.model.Role.wrap(buildAwsValue())
}
object Role {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.auditmanager.model.Role] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Role = zio.aws.auditmanager.model
      .Role(roleType.map(value => value), roleArn.map(value => value))
    def roleType: Option[zio.aws.auditmanager.model.RoleType]
    def roleArn: Option[IamArn]
    def getRoleType: ZIO[Any, AwsError, zio.aws.auditmanager.model.RoleType] =
      AwsError.unwrapOptionField("roleType", roleType)
    def getRoleArn: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Role
  ) extends zio.aws.auditmanager.model.Role.ReadOnly {
    override val roleType: Option[zio.aws.auditmanager.model.RoleType] = scala
      .Option(impl.roleType())
      .map(value => zio.aws.auditmanager.model.RoleType.wrap(value))
    override val roleArn: Option[IamArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Role
  ): zio.aws.auditmanager.model.Role.ReadOnly = new Wrapper(impl)
}
