package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListAssessmentControlInsightsByControlDomainResponse(
    controlInsightsByAssessment: Option[Iterable[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem
    ]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse = {
    import ListAssessmentControlInsightsByControlDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
      .builder()
      .optionallyWith(
        controlInsightsByAssessment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlInsightsByAssessment)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
      .wrap(buildAwsValue())
}
object ListAssessmentControlInsightsByControlDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse =
      zio.aws.auditmanager.model
        .ListAssessmentControlInsightsByControlDomainResponse(
          controlInsightsByAssessment.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def controlInsightsByAssessment: Option[List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]]
    def nextToken: Option[Token]
    def getControlInsightsByAssessment: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "controlInsightsByAssessment",
      controlInsightsByAssessment
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly {
    override val controlInsightsByAssessment: Option[List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]] = scala
      .Option(impl.controlInsightsByAssessment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ): zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly =
    new Wrapper(impl)
}
