package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInsightsResponse(
    insights: Option[zio.aws.auditmanager.model.Insights] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse = {
    import GetInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse
      .builder()
      .optionallyWith(insights.map(value => value.buildAwsValue()))(_.insights)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly =
    zio.aws.auditmanager.model.GetInsightsResponse.wrap(buildAwsValue())
}
object GetInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetInsightsResponse =
      zio.aws.auditmanager.model
        .GetInsightsResponse(insights.map(value => value.asEditable))
    def insights: Option[zio.aws.auditmanager.model.Insights.ReadOnly]
    def getInsights
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Insights.ReadOnly] =
      AwsError.unwrapOptionField("insights", insights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse
  ) extends zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly {
    override val insights
        : Option[zio.aws.auditmanager.model.Insights.ReadOnly] = scala
      .Option(impl.insights())
      .map(value => zio.aws.auditmanager.model.Insights.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsResponse
  ): zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly = new Wrapper(impl)
}
