package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters._
sealed trait DelegationStatus {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.DelegationStatus
}
object DelegationStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.DelegationStatus
  ): zio.aws.auditmanager.model.DelegationStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.DelegationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.DelegationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.auditmanager.model.DelegationStatus.UNDER_REVIEW =>
      val r = UNDER_REVIEW
      r
    case software.amazon.awssdk.services.auditmanager.model.DelegationStatus.COMPLETE =>
      val r = COMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.DelegationStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.DelegationStatus =
      software.amazon.awssdk.services.auditmanager.model.DelegationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.auditmanager.model.DelegationStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.DelegationStatus =
      software.amazon.awssdk.services.auditmanager.model.DelegationStatus.IN_PROGRESS
  }
  case object UNDER_REVIEW extends zio.aws.auditmanager.model.DelegationStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.DelegationStatus =
      software.amazon.awssdk.services.auditmanager.model.DelegationStatus.UNDER_REVIEW
  }
  case object COMPLETE extends zio.aws.auditmanager.model.DelegationStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.DelegationStatus =
      software.amazon.awssdk.services.auditmanager.model.DelegationStatus.COMPLETE
  }
}
