package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentName,
  Timestamp,
  DelegationComment,
  IamArn,
  UUID,
  CreatedBy
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Delegation(
    id: Option[UUID] = None,
    assessmentName: Option[AssessmentName] = None,
    assessmentId: Option[UUID] = None,
    status: Option[zio.aws.auditmanager.model.DelegationStatus] = None,
    roleArn: Option[IamArn] = None,
    roleType: Option[zio.aws.auditmanager.model.RoleType] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdated: Option[Timestamp] = None,
    controlSetId: Option[ControlSetId] = None,
    comment: Option[DelegationComment] = None,
    createdBy: Option[CreatedBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Delegation = {
    import Delegation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Delegation
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(roleType.map(value => value.unwrap))(_.roleType)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        comment.map(value => DelegationComment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Delegation.ReadOnly =
    zio.aws.auditmanager.model.Delegation.wrap(buildAwsValue())
}
object Delegation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Delegation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Delegation =
      zio.aws.auditmanager.model.Delegation(
        id.map(value => value),
        assessmentName.map(value => value),
        assessmentId.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        roleType.map(value => value),
        creationTime.map(value => value),
        lastUpdated.map(value => value),
        controlSetId.map(value => value),
        comment.map(value => value),
        createdBy.map(value => value)
      )
    def id: Option[UUID]
    def assessmentName: Option[AssessmentName]
    def assessmentId: Option[UUID]
    def status: Option[zio.aws.auditmanager.model.DelegationStatus]
    def roleArn: Option[IamArn]
    def roleType: Option[zio.aws.auditmanager.model.RoleType]
    def creationTime: Option[Timestamp]
    def lastUpdated: Option[Timestamp]
    def controlSetId: Option[ControlSetId]
    def comment: Option[DelegationComment]
    def createdBy: Option[CreatedBy]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.DelegationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRoleType: ZIO[Any, AwsError, zio.aws.auditmanager.model.RoleType] =
      AwsError.unwrapOptionField("roleType", roleType)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getComment: ZIO[Any, AwsError, DelegationComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Delegation
  ) extends zio.aws.auditmanager.model.Delegation.ReadOnly {
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Option[AssessmentName] = scala
      .Option(impl.assessmentName())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val assessmentId: Option[UUID] = scala
      .Option(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val status: Option[zio.aws.auditmanager.model.DelegationStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.auditmanager.model.DelegationStatus.wrap(value))
    override val roleArn: Option[IamArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val roleType: Option[zio.aws.auditmanager.model.RoleType] = scala
      .Option(impl.roleType())
      .map(value => zio.aws.auditmanager.model.RoleType.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val controlSetId: Option[ControlSetId] = scala
      .Option(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val comment: Option[DelegationComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.DelegationComment(value)
      )
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Delegation
  ): zio.aws.auditmanager.model.Delegation.ReadOnly = new Wrapper(impl)
}
