package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  IamArn,
  ControlSetId,
  DelegationComment
}
import scala.jdk.CollectionConverters._
final case class CreateDelegationRequest(
    comment: Option[DelegationComment] = None,
    controlSetId: Option[ControlSetId] = None,
    roleArn: Option[IamArn] = None,
    roleType: Option[zio.aws.auditmanager.model.RoleType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest = {
    import CreateDelegationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest
      .builder()
      .optionallyWith(
        comment.map(value => DelegationComment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        roleArn.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(roleType.map(value => value.unwrap))(_.roleType)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly =
    zio.aws.auditmanager.model.CreateDelegationRequest.wrap(buildAwsValue())
}
object CreateDelegationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateDelegationRequest =
      zio.aws.auditmanager.model.CreateDelegationRequest(
        comment.map(value => value),
        controlSetId.map(value => value),
        roleArn.map(value => value),
        roleType.map(value => value)
      )
    def comment: Option[DelegationComment]
    def controlSetId: Option[ControlSetId]
    def roleArn: Option[IamArn]
    def roleType: Option[zio.aws.auditmanager.model.RoleType]
    def getComment: ZIO[Any, AwsError, DelegationComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getRoleArn: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRoleType: ZIO[Any, AwsError, zio.aws.auditmanager.model.RoleType] =
      AwsError.unwrapOptionField("roleType", roleType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest
  ) extends zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly {
    override val comment: Option[DelegationComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.DelegationComment(value)
      )
    override val controlSetId: Option[ControlSetId] = scala
      .Option(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val roleArn: Option[IamArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val roleType: Option[zio.aws.auditmanager.model.RoleType] = scala
      .Option(impl.roleType())
      .map(value => zio.aws.auditmanager.model.RoleType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateDelegationRequest
  ): zio.aws.auditmanager.model.CreateDelegationRequest.ReadOnly = new Wrapper(
    impl
  )
}
