package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.AWSServiceName
import scala.jdk.CollectionConverters._
final case class AWSService(serviceName: Option[AWSServiceName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AWSService = {
    import AWSService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AWSService
      .builder()
      .optionallyWith(
        serviceName.map(value => AWSServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AWSService.ReadOnly =
    zio.aws.auditmanager.model.AWSService.wrap(buildAwsValue())
}
object AWSService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AWSService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AWSService =
      zio.aws.auditmanager.model.AWSService(serviceName.map(value => value))
    def serviceName: Option[AWSServiceName]
    def getServiceName: ZIO[Any, AwsError, AWSServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSService
  ) extends zio.aws.auditmanager.model.AWSService.ReadOnly {
    override val serviceName: Option[AWSServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.auditmanager.model.primitives.AWSServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSService
  ): zio.aws.auditmanager.model.AWSService.ReadOnly = new Wrapper(impl)
}
