package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.S3Url
import scala.jdk.CollectionConverters._
final case class ManualEvidence(s3ResourcePath: Option[S3Url] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ManualEvidence = {
    import ManualEvidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ManualEvidence
      .builder()
      .optionallyWith(
        s3ResourcePath.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.s3ResourcePath)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ManualEvidence.ReadOnly =
    zio.aws.auditmanager.model.ManualEvidence.wrap(buildAwsValue())
}
object ManualEvidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ManualEvidence =
      zio.aws.auditmanager.model
        .ManualEvidence(s3ResourcePath.map(value => value))
    def s3ResourcePath: Option[S3Url]
    def getS3ResourcePath: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("s3ResourcePath", s3ResourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ) extends zio.aws.auditmanager.model.ManualEvidence.ReadOnly {
    override val s3ResourcePath: Option[S3Url] = scala
      .Option(impl.s3ResourcePath())
      .map(value => zio.aws.auditmanager.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ): zio.aws.auditmanager.model.ManualEvidence.ReadOnly = new Wrapper(impl)
}
