package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetServicesInScopeResponse(
    serviceMetadata: Option[
      Iterable[zio.aws.auditmanager.model.ServiceMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse = {
    import GetServicesInScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
      .builder()
      .optionallyWith(
        serviceMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly =
    zio.aws.auditmanager.model.GetServicesInScopeResponse.wrap(buildAwsValue())
}
object GetServicesInScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetServicesInScopeResponse =
      zio.aws.auditmanager.model.GetServicesInScopeResponse(
        serviceMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceMetadata
        : Option[List[zio.aws.auditmanager.model.ServiceMetadata.ReadOnly]]
    def getServiceMetadata: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ServiceMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ) extends zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly {
    override val serviceMetadata
        : Option[List[zio.aws.auditmanager.model.ServiceMetadata.ReadOnly]] =
      scala
        .Option(impl.serviceMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ServiceMetadata.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeResponse
  ): zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly =
    new Wrapper(impl)
}
