package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateControlResponse(
    control: Option[zio.aws.auditmanager.model.Control] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateControlResponse = {
    import CreateControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateControlResponse
      .builder()
      .optionallyWith(control.map(value => value.buildAwsValue()))(_.control)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.CreateControlResponse.ReadOnly =
    zio.aws.auditmanager.model.CreateControlResponse.wrap(buildAwsValue())
}
object CreateControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.CreateControlResponse =
      zio.aws.auditmanager.model
        .CreateControlResponse(control.map(value => value.asEditable))
    def control: Option[zio.aws.auditmanager.model.Control.ReadOnly]
    def getControl
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Control.ReadOnly] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlResponse
  ) extends zio.aws.auditmanager.model.CreateControlResponse.ReadOnly {
    override val control: Option[zio.aws.auditmanager.model.Control.ReadOnly] =
      scala
        .Option(impl.control())
        .map(value => zio.aws.auditmanager.model.Control.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateControlResponse
  ): zio.aws.auditmanager.model.CreateControlResponse.ReadOnly = new Wrapper(
    impl
  )
}
