package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDelegationByAssessmentResponse(
    errors: Option[Iterable[
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse = {
    import BatchDeleteDelegationByAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
      .wrap(buildAwsValue())
}
object BatchDeleteDelegationByAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse =
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Option[List[
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly
    ]]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
  ) extends zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly {
    override val errors: Option[List[
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError.ReadOnly
    ]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
  ): zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
