package zio.aws.auditmanager.model
import java.time.Instant
import zio.aws.auditmanager.model.primitives.{Timestamp, NullableInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Insights(
    activeAssessmentsCount: Option[NullableInteger] = None,
    noncompliantEvidenceCount: Option[NullableInteger] = None,
    compliantEvidenceCount: Option[NullableInteger] = None,
    inconclusiveEvidenceCount: Option[NullableInteger] = None,
    assessmentControlsCountByNoncompliantEvidence: Option[NullableInteger] =
      None,
    totalAssessmentControlsCount: Option[NullableInteger] = None,
    lastUpdated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Insights = {
    import Insights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Insights
      .builder()
      .optionallyWith(
        activeAssessmentsCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.activeAssessmentsCount)
      .optionallyWith(
        noncompliantEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.noncompliantEvidenceCount)
      .optionallyWith(
        compliantEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.compliantEvidenceCount)
      .optionallyWith(
        inconclusiveEvidenceCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.inconclusiveEvidenceCount)
      .optionallyWith(
        assessmentControlsCountByNoncompliantEvidence.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.assessmentControlsCountByNoncompliantEvidence)
      .optionallyWith(
        totalAssessmentControlsCount.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.totalAssessmentControlsCount)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Insights.ReadOnly =
    zio.aws.auditmanager.model.Insights.wrap(buildAwsValue())
}
object Insights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Insights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Insights =
      zio.aws.auditmanager.model.Insights(
        activeAssessmentsCount.map(value => value),
        noncompliantEvidenceCount.map(value => value),
        compliantEvidenceCount.map(value => value),
        inconclusiveEvidenceCount.map(value => value),
        assessmentControlsCountByNoncompliantEvidence.map(value => value),
        totalAssessmentControlsCount.map(value => value),
        lastUpdated.map(value => value)
      )
    def activeAssessmentsCount: Option[NullableInteger]
    def noncompliantEvidenceCount: Option[NullableInteger]
    def compliantEvidenceCount: Option[NullableInteger]
    def inconclusiveEvidenceCount: Option[NullableInteger]
    def assessmentControlsCountByNoncompliantEvidence: Option[NullableInteger]
    def totalAssessmentControlsCount: Option[NullableInteger]
    def lastUpdated: Option[Timestamp]
    def getActiveAssessmentsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "activeAssessmentsCount",
        activeAssessmentsCount
      )
    def getNoncompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "noncompliantEvidenceCount",
        noncompliantEvidenceCount
      )
    def getCompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "compliantEvidenceCount",
        compliantEvidenceCount
      )
    def getInconclusiveEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "inconclusiveEvidenceCount",
        inconclusiveEvidenceCount
      )
    def getAssessmentControlsCountByNoncompliantEvidence
        : ZIO[Any, AwsError, NullableInteger] = AwsError.unwrapOptionField(
      "assessmentControlsCountByNoncompliantEvidence",
      assessmentControlsCountByNoncompliantEvidence
    )
    def getTotalAssessmentControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "totalAssessmentControlsCount",
        totalAssessmentControlsCount
      )
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Insights
  ) extends zio.aws.auditmanager.model.Insights.ReadOnly {
    override val activeAssessmentsCount: Option[NullableInteger] = scala
      .Option(impl.activeAssessmentsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val noncompliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.noncompliantEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val compliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.compliantEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val inconclusiveEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.inconclusiveEvidenceCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val assessmentControlsCountByNoncompliantEvidence
        : Option[NullableInteger] = scala
      .Option(impl.assessmentControlsCountByNoncompliantEvidence())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val totalAssessmentControlsCount: Option[NullableInteger] = scala
      .Option(impl.totalAssessmentControlsCount())
      .map(value =>
        zio.aws.auditmanager.model.primitives.NullableInteger(value)
      )
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Insights
  ): zio.aws.auditmanager.model.Insights.ReadOnly = new Wrapper(impl)
}
