package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters._
final case class CreateAssessmentFrameworkControl(id: Option[UUID] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl = {
    import CreateAssessmentFrameworkControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly =
    zio.aws.auditmanager.model.CreateAssessmentFrameworkControl
      .wrap(buildAwsValue())
}
object CreateAssessmentFrameworkControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.CreateAssessmentFrameworkControl =
      zio.aws.auditmanager.model
        .CreateAssessmentFrameworkControl(id.map(value => value))
    def id: Option[UUID]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl
  ) extends zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly {
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkControl
  ): zio.aws.auditmanager.model.CreateAssessmentFrameworkControl.ReadOnly =
    new Wrapper(impl)
}
