package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetControlResponse(
    control: Option[zio.aws.auditmanager.model.Control] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetControlResponse = {
    import GetControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetControlResponse
      .builder()
      .optionallyWith(control.map(value => value.buildAwsValue()))(_.control)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetControlResponse.ReadOnly =
    zio.aws.auditmanager.model.GetControlResponse.wrap(buildAwsValue())
}
object GetControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetControlResponse =
      zio.aws.auditmanager.model
        .GetControlResponse(control.map(value => value.asEditable))
    def control: Option[zio.aws.auditmanager.model.Control.ReadOnly]
    def getControl
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Control.ReadOnly] =
      AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetControlResponse
  ) extends zio.aws.auditmanager.model.GetControlResponse.ReadOnly {
    override val control: Option[zio.aws.auditmanager.model.Control.ReadOnly] =
      scala
        .Option(impl.control())
        .map(value => zio.aws.auditmanager.model.Control.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetControlResponse
  ): zio.aws.auditmanager.model.GetControlResponse.ReadOnly = new Wrapper(impl)
}
