package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  NotebookName,
  ClientRequestToken,
  NotebookId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNotebookMetadataRequest(
    notebookId: NotebookId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    name: NotebookName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest = {
    import UpdateNotebookMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest
      .builder()
      .notebookId(NotebookId.unwrap(notebookId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .name(NotebookName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdateNotebookMetadataRequest.ReadOnly =
    zio.aws.athena.model.UpdateNotebookMetadataRequest.wrap(buildAwsValue())
}
object UpdateNotebookMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateNotebookMetadataRequest =
      zio.aws.athena.model.UpdateNotebookMetadataRequest(
        notebookId,
        clientRequestToken.map(value => value),
        name
      )
    def notebookId: NotebookId
    def clientRequestToken: Optional[ClientRequestToken]
    def name: NotebookName
    def getNotebookId: ZIO[Any, Nothing, NotebookId] = ZIO.succeed(notebookId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, Nothing, NotebookName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest
  ) extends zio.aws.athena.model.UpdateNotebookMetadataRequest.ReadOnly {
    override val notebookId: NotebookId =
      zio.aws.athena.model.primitives.NotebookId(impl.notebookId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.athena.model.primitives.ClientRequestToken(value))
    override val name: NotebookName =
      zio.aws.athena.model.primitives.NotebookName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateNotebookMetadataRequest
  ): zio.aws.athena.model.UpdateNotebookMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
