package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{
  CapacityReservationName,
  TargetDpusInteger
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCapacityReservationRequest(
    targetDpus: TargetDpusInteger,
    name: CapacityReservationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest = {
    import UpdateCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest
      .builder()
      .targetDpus(TargetDpusInteger.unwrap(targetDpus): Integer)
      .name(CapacityReservationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.athena.model.UpdateCapacityReservationRequest.ReadOnly =
    zio.aws.athena.model.UpdateCapacityReservationRequest.wrap(buildAwsValue())
}
object UpdateCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateCapacityReservationRequest =
      zio.aws.athena.model.UpdateCapacityReservationRequest(targetDpus, name)
    def targetDpus: TargetDpusInteger
    def name: CapacityReservationName
    def getTargetDpus: ZIO[Any, Nothing, TargetDpusInteger] =
      ZIO.succeed(targetDpus)
    def getName: ZIO[Any, Nothing, CapacityReservationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest
  ) extends zio.aws.athena.model.UpdateCapacityReservationRequest.ReadOnly {
    override val targetDpus: TargetDpusInteger =
      zio.aws.athena.model.primitives.TargetDpusInteger(impl.targetDpus())
    override val name: CapacityReservationName =
      zio.aws.athena.model.primitives.CapacityReservationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateCapacityReservationRequest
  ): zio.aws.athena.model.UpdateCapacityReservationRequest.ReadOnly =
    new Wrapper(impl)
}
