package zio.aws.athena.model
import zio.aws.athena.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TerminateSessionRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.TerminateSessionRequest = {
    import TerminateSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.TerminateSessionRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.TerminateSessionRequest.ReadOnly =
    zio.aws.athena.model.TerminateSessionRequest.wrap(buildAwsValue())
}
object TerminateSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.TerminateSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.TerminateSessionRequest =
      zio.aws.athena.model.TerminateSessionRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.TerminateSessionRequest
  ) extends zio.aws.athena.model.TerminateSessionRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.athena.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.TerminateSessionRequest
  ): zio.aws.athena.model.TerminateSessionRequest.ReadOnly = new Wrapper(impl)
}
