package zio.aws.athena.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.athena.model.primitives.{DescriptionString, Date}
import scala.jdk.CollectionConverters.*
final case class SessionStatus(
    startDateTime: Optional[Date] = Optional.Absent,
    lastModifiedDateTime: Optional[Date] = Optional.Absent,
    endDateTime: Optional[Date] = Optional.Absent,
    idleSinceDateTime: Optional[Date] = Optional.Absent,
    state: Optional[zio.aws.athena.model.SessionState] = Optional.Absent,
    stateChangeReason: Optional[DescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.SessionStatus = {
    import SessionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.SessionStatus
      .builder()
      .optionallyWith(startDateTime.map(value => Date.unwrap(value): Instant))(
        _.startDateTime
      )
      .optionallyWith(
        lastModifiedDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDateTime)
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .optionallyWith(
        idleSinceDateTime.map(value => Date.unwrap(value): Instant)
      )(_.idleSinceDateTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateChangeReason.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.stateChangeReason)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.SessionStatus.ReadOnly =
    zio.aws.athena.model.SessionStatus.wrap(buildAwsValue())
}
object SessionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.SessionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.SessionStatus =
      zio.aws.athena.model.SessionStatus(
        startDateTime.map(value => value),
        lastModifiedDateTime.map(value => value),
        endDateTime.map(value => value),
        idleSinceDateTime.map(value => value),
        state.map(value => value),
        stateChangeReason.map(value => value)
      )
    def startDateTime: Optional[Date]
    def lastModifiedDateTime: Optional[Date]
    def endDateTime: Optional[Date]
    def idleSinceDateTime: Optional[Date]
    def state: Optional[zio.aws.athena.model.SessionState]
    def stateChangeReason: Optional[DescriptionString]
    def getStartDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getLastModifiedDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDateTime", lastModifiedDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getIdleSinceDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("idleSinceDateTime", idleSinceDateTime)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.SessionState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.SessionStatus
  ) extends zio.aws.athena.model.SessionStatus.ReadOnly {
    override val startDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val lastModifiedDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val endDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val idleSinceDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.idleSinceDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val state: Optional[zio.aws.athena.model.SessionState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.athena.model.SessionState.wrap(value))
    override val stateChangeReason: Optional[DescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateChangeReason())
        .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.SessionStatus
  ): zio.aws.athena.model.SessionStatus.ReadOnly = new Wrapper(impl)
}
