package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResultReuseConfiguration(
    resultReuseByAgeConfiguration: Optional[
      zio.aws.athena.model.ResultReuseByAgeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultReuseConfiguration = {
    import ResultReuseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultReuseConfiguration
      .builder()
      .optionallyWith(
        resultReuseByAgeConfiguration.map(value => value.buildAwsValue())
      )(_.resultReuseByAgeConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultReuseConfiguration.ReadOnly =
    zio.aws.athena.model.ResultReuseConfiguration.wrap(buildAwsValue())
}
object ResultReuseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultReuseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultReuseConfiguration =
      zio.aws.athena.model.ResultReuseConfiguration(
        resultReuseByAgeConfiguration.map(value => value.asEditable)
      )
    def resultReuseByAgeConfiguration
        : Optional[zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly]
    def getResultReuseByAgeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resultReuseByAgeConfiguration",
      resultReuseByAgeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseConfiguration
  ) extends zio.aws.athena.model.ResultReuseConfiguration.ReadOnly {
    override val resultReuseByAgeConfiguration: Optional[
      zio.aws.athena.model.ResultReuseByAgeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resultReuseByAgeConfiguration())
      .map(value =>
        zio.aws.athena.model.ResultReuseByAgeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultReuseConfiguration
  ): zio.aws.athena.model.ResultReuseConfiguration.ReadOnly = new Wrapper(impl)
}
